function cosSimilarity(obj,varargin)
%COSSIMILARITY Calculate similarity matrix for this SimilarityMatrix
%object using the cosine similarity

if ~isempty(obj.groups)
    
    outMat = combineCells(obj.adjMat,{},obj.groups);
    inMat = combineCells(obj.adjMat,obj.groups,{});
    [Aout outRowLabs outColLabs] = getMatrix(outMat);
    [Ain inRowLabs inColLabs] = getMatrix(inMat);
    switch obj.direction
        case 'outgoing'
            num = Aout*Aout';
            obj.Slabels = outRowLabs;
        case 'incoming'
            num = Ain'*Ain;
            obj.Slabels = inRowLabs;
        case 'both'
            num = AdjacencyMatrix(Aout*Aout',outRowLabs,outRowLabs) + AdjacencyMatrix(Ain'*Ain,inColLabs,inColLabs);
            [num obj.Slabels] = getSquareMatrix(num);
    end
    
    
else
    switch obj.direction
        case 'outgoing'
            [A obj.Slabels tmp] = getMatrix(obj.adjMat);
            num = A*A';
        case 'incoming'
            [A tmp obj.Slabels] = getMatrix(obj.adjMat);
            num = A'*A;
        case 'both'
            [A obj.Slabels] = getSquareMatrix(obj.adjMat);
            num = A*A' + A'*A;
    end

end
% size(Aout)
% size(Ain)
denom = (diag(num) * diag(num)').^(1/2);
% denom = diag((obj.outWeight).*A*A' + (obj.inWeight).*A'*A) * ...
%     diag((obj.outWeight).*A*A' + (obj.inWeight).*A'*A)';

obj.S = num./denom;

end

